local MAX_STORAGE = 10
local FILL_TIME = 12000

function main(self)
	if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.detector = GetObject(3206)
		self.hud = CreateHUDObject{
			X = self.detector.ScreenW - 20,
			Y = GetGameType() == GameType.MultiPlayer and 72 or 98,
			Z = 10050,
			logic="DoNothing",
			image = "CUSTOM_INTERFACE_HB"
		}
		self.State = 1
	end

	if self.State == 1 then
		self.storedTime, self.soundDelay = 0, 0
		self.countTime = GetTime()
		self.hud:SetFrame(0)
		self.State = 2
	end

	if self.State > 1 then
		self.storedTime = math.floor((GetTime() - self.countTime)/FILL_TIME)
		self.storedTime = self.storedTime > MAX_STORAGE and MAX_STORAGE or self.storedTime
		self.hud:SetFrame(self.storedTime)
	end

	if self.State == 2 then
		if GetInput"Special" then
			if self.storedTime > 0 then
				ClawGivePowerup(Powerup.Catnip, self.storedTime)
				PlaySound("GAME_CATNMAG")
				self.State = 3
			elseif GetTime() > self.soundDelay and _CurrentPowerup[0] ~= Powerup.Catnip then
				ClawSound("CUSTOM_TRIGGER_NAH")
			end
			self.soundDelay = GetTime() + 1500
		end
		if GetClaw().Health <= 0 then
			self.State = 1
		end
	end

	if self.State == 3 and not GetInput"Special" then
		self.State = 1
	end

end
